/*
	$DOCFILE:CAPI.H

	Copyright (C) 1999-2000 Datalight, Inc.
	All Rights Reserved

	Sockets Compatible API (CAPI) header file

	$DOCHISTORY:
	     2001-05-11 used ISR_ROUTINE after cleanup.
	     2001-04-19 jmb changed ISR_ROUTINE to _loadds
	2.11 2001-03-30 IOCTL PPP OPEN,START,CLOSE
	2.10 2000-12-09 pkg Factored out non portable code
	2.01 2000-06-27 Adding MSVC compatibilaty.
	2.02 2000-11-29 pkg Began makeing changes for portability
	2.00 2000-05-24 IOCTL
	1.20 1999-12-04 Added IGMP
	1.10 1999-07-02 Sockets 1.1 release
	1.02 1999-05-27 New version using Datalight Coding guidelines
	1.01 1999-04-29 Added documentation on async callbacks.
	1.00 1999-03-18 Starting version control
*/

/*
	The following globals are set after each call into sockets
	and indicate particular error codes upon failure of a
	function.
*/
extern int iNetErrNo;
extern int iNetSubErrNo;


/*
	Function numbers (AH) used to call into the Socekts API
*/
#define GET_BUSY_FLAG               0x01
#define GET_KERNEL_INFO             0x02
#define GET_ADDRESS                 0x05
#define GET_NET_INFO                0x06
#define CONVERT_DC_SOCKET           0x07
#define RELEASE_SOCKET              0x08
#define RELEASE_DC_SOCKETS          0x09
#define IS_SOCKET                   0x0d
#define SELECT_SOCKET               0x0e
#define GET_NET_VERSION             0x0f
#define SHUT_DOWN_NET               0x10
#define DISABLE_ASYNC_NOTIFICATION  0x11
#define ENABLE_ASYNC_NOTIFICATION   0x12
#define CONNECT_SOCKET              0x13
#define GET_PEER_ADDRESS            0x16
#define EOF_SOCKET                  0x18
#define ABORT_SOCKET                0x19
#define WRITE_SOCKET                0x1a
#define READ_SOCKET                 0x1b
#define WRITE_TO_SOCKET             0x1c
#define READ_FROM_SOCKET            0x1d
#define FLUSH_SOCKET                0x1e
#define SET_ASYNC_NOTIFICATION      0x1f
#define SET_OPTION                  0x20
#define GET_DC_SOCKET               0x22
#define LISTEN_SOCKET               0x23
#define ABORT_DC_SOCKETS            0x24
#define GET_SOCKET                  0x29
#define GET_KERNEL_CONFIG           0x2a
#define SET_ALARM                   0x2b
#define ICMP_PING                   0x30
#define PARSE_ADDRESS               0x50
#define LOOKUP_HOST_TABLE           0x51
#define RESOLVE_NAME                0x54
#define JOIN_GROUP                  0x60
#define LEAVE_GROUP                 0x61
#define IFACE_IOCTL                 0x62
#define GET_SOCKETS_VERSION         0x63

/* IOCTL functions */
#define IOCTL_CONNECT               0   /* start dial on ASY */
#define IOCTL_DISCONNECT            1   /* drop modem on ASY */
#define IOCTL_ENABLEPORT            2   /* enable port on ASY */
#define IOCTL_DISABLEPORT           3   /* disable port on ASY */
#define IOCTL_ENABLEDOD             4   /* enable-dial-on-demand */
#define IOCTL_DISABLEDOD            5   /* disable dial-on-demand */
#define IOCTL_GETSTATUS             6   /* get dial status */
#define IOCTL_PPP_OPEN              7   /* Open PPP */
#define IOCTL_PPP_START             8   /* Start PPP */
#define IOCTL_PPP_CLOSE             9   /* Close PPP */

/* Status bits returned on IOCTL_GETSTATUS */
#define ST_DTR                      0x01   /* Modem Data Terminal Ready */
#define ST_RTS                      0x02   /* Request To Send */
#define ST_CTS                      0x04   /* Clear To Send */
#define ST_DSR                      0x08   /* Data Set Ready */
#define ST_RI                       0x10   /* Ring Indicator */
#define ST_DCD                      0x20   /* Data Carrier Detect */
#define ST_CONNECTED                0x40   /* Modem is connected */
#define ST_MODEMSTATE               0x700  /* Modem state mask */
#define STM_NONE                    0x000  /* No modem on port */
#define STM_IDLE                    0x100  /* Modem is idle */
#define STM_INITIALIZING            0x200  /* Modem is initializing */
#define STM_DIALING                 0x300  /* Modem is dialing */
#define STM_CONNECTING              0x400  /* Modem is connecting */
#define STM_ANSWERING               0x500  /* Modem is answering */
#define STPPPP_IN                   0x800  /* PPP incoming call */
#define STPPP_STATE                 0x7000 /* PPP state */
#define STPPP_DEAD                  0x0000 /* PPP dead */
#define STPPP_LCP                   0x1000 /* PPP LCP state */
#define STPPP_AP                    0x2000 /* PPP Authentication state */
#define STPPP_READY                 0x3000 /* PPP Ready (IPCP state) */
#define STPPP_TERMINATING           0x4000 /* PPP Terminating */


/*
	If an error occurs, the Carry Flag is set and an error code is
	returned in the AX register as follows:
*/
#define NO_ERR                      0   /* No error */
#define ERR_IN_USE                  1   /* A connection alreadyexists */
#define ERR_DOS                     2   /* A DOS error occured */
#define ERR_NO_MEM                  3   /* No memory to perform function */
#define ERR_NOT_NET_CONN            4   /* Connection does not exist */
#define ERR_ILLEGAL_OP              5   /* Protocol or mode not supported */
#define ERR_NO_HOST                 7   /* No host address specified */
#define ERR_TIMEOUT                 13  /* The function timed out */
#define ERR_HOST_UNKNOWN            14  /* Unknown host has been specified */
#define ERR_BAD_ARG                 18  /* Bad arguments */
#define ERR_EOF                     19  /* Connection closed by peer */
#define ERR_RESET                   20  /* Connection reset by peer */
#define ERR_WOULD_BLOCK             21  /* Operation would block */
#define ERR_UNBOUND                 22  /* Descriptor not yet assigned */
#define ERR_NO_SOCKET               23  /* No descriptor is available */
#define ERR_BAD_SYS_CALL            24  /* Bad parameter in call */
#define ERR_NOT_ESTAB               26  /* Connection not yet established */
#define ERR_RE_ENTRY                27  /* Kernel use, try again later */
#define ERR_TERMINATING             29  /* Kernel unloading */
#define ERR_API_NOT_LOADED          50  /* API is not loaded */

/* connection types for ConnectSocket() and ListenSocket() */
#define DATA_GRAM       3
#define STREAM          4


/* Network address structure for NetConnect() and NetListen() */
typedef struct NET_ADDR
{
	DWORD dwRemoteHost;  /* IP address of remote host */
	WORD wRemotePort;    /* Remote port address */
	WORD wLocalPort;     /* Local port address */
	BYTE bProtocol;      /* Protocol */
} NET_ADDR;


/*
	Flags for ReadSocket(), ReadFrom, NetRecv, NetRecvFrom,
	NetWrite, NetWriteTo, NetSend, NetSendTo
*/
#define NET_FLG_OOB                 0x0001  /* Out of band data */
#define NET_FLG_PEEK                0x0002  /* Don't dequeue data */
#define NET_FLG_PUSH                0x0010  /* Disregard Nagle heuristic */
#define NET_FLG_NON_BLOCKING        0x0040  /* Don't block */
#define NET_FLG_BROADCAST           0x0080  /* Broadcast data */
#define NET_FLG_MC_NOECHO           0x1000  /* Don't echo multicast */

/* Values used in SetOption */
#define NET_OPT_NON_BLOCKING        0x01    /* Don't block on system calls */
#define NET_OPT_TIMEOUT             0x02    /* Timeout system calls */
#define NET_OPT_KEEPALIVE           0x06    /* TCP keepalive */
#define NET_OPT_WAIT_FLUSH          0x0C    /* Honor NetFlgPush on socket */

/* values for Async Notification routines */
#define NET_AS_ALARM                0x00
#define NET_AS_OPEN                 0x01
#define NET_AS_RCV                  0x02
#define NET_AS_XMT                  0x03
#define NET_AS_XMT_FLUSH            0x04
#define NET_AS_FCLOSE               0x05
#define NET_AS_CLOSE                0x06
#define NET_AS_ERROR                0x07

#define MAX_AS_EVENT                NET_AS_ERROR

/* NetInfo structure */
typedef struct netinfo
{
	int iClass;
	int iType;
	int iNumber;
	DWORD dwIpAddress;
	DWORD dwIpSubnet;
	int iUp;
	DWORD dwIn;
	DWORD dwOut;          /* # of packets transmitted */
	DWORD dwInErr;        /* # of receiver errors */
	DWORD dwOutErr;       /* # of transmitter errors */
	int     iLanLen;      /* length of local net address */
	BYTE D_FAR *pLanAddr;/* pointer to the lan address */
} NET_INFO;


/* kernel configuration */
typedef struct kernel_conf {
	BYTE	bKMaxTcp;       /* # of TCP connections allowed */
	BYTE	bKMaxUdp;       /* # of UDP connections allowed */
	BYTE	bKMaxIp;        /* # of IP connections allowed */
	BYTE	bKMaxRaw;       /* # of RAW_NET connections allowed */
	BYTE	bKActTcp;       /* # of TCP connections in use */
	BYTE	bKActUdp;       /* # of UDP connections in use */
	BYTE	bKActIp;        /* # of IP connections in use */
	BYTE	bKActRaw;       /* # of RAW_NET connections in use */
	WORD	wKActDCS;       /* # of active Dos Compatible Sockets */
	WORD	wKActSoc;       /* # of active Sockets */
	BYTE	bKMaxLnh;       /* Maximum header on an attached network */
	BYTE	bKMaxLnt;       /* Maximum trailer on an attached network */
	WORD	bKLBUF_SIZE;    /* Size of a large packet buffer */
	WORD	bKNnet;         /* Number of network interfaces attached */
	DWORD	dwKCticks;      /* Milliseconds since kernel started */
	DWORD	dwKBroadcast;   /* IP broadcast address in use */
} KERNEL_CONFIG;

/* kernel info */
#define K_INF_TCP_CONS      0x04
#define K_INF_HOST_TABLE    0x08
#define K_INF_DNS_SERVERS   0x09
#define K_INF_HOSTNAME      0x5a
#define K_INF_MAC_ADDR      0x81
#define K_INF_BCAST_ADDR    0x84
#define K_INF_IP_ADDR       0x82
#define K_INF_SUBNET_MASK   0x85

/* Group address structure for JoinGroup() and LeaveGroup() */
typedef struct group_addr
{
	DWORD dwGroupAddr;	/* group address */
	DWORD dwIFAddr;		/* IP address of interface to use, 0 for default */
} GROUP_ADDR;


int DisableAsyncNotification(void);
int EnableAsyncNotification(void);
DWORD GetAddress(int iSocket);
int GetPeerAddress(int iSocket, NET_ADDR *psAddr);
int GetKernelInformation(int iReserved,BYTE bCode,BYTE bDevID,
						 void *pData,WORD *pwSize);
int GetVersion(void);
int ICMPPing(DWORD dwHost, int iLength);
int IsSocket(int iSocket);
int GetDCSocket(void);
int GetSocket(void);
int GetKernelConfig(KERNEL_CONFIG *psKC);
int ConvertDCSocket(int iSocket);
int GetNetInfo(int iSocket,NET_INFO *psNI);
int ConnectSocket(int iSocket, int iType, NET_ADDR *psAddr);
int ListenSocket(int iSocket, int iType, NET_ADDR *psAddr);
int SelectSocket(int iMaxID, long *plIflags, long *plOflags);
int ReadSocket(int iSocket, char *pcBuf, WORD wLen,
			   NET_ADDR *psFrom, WORD wFlags);
int ReadFromSocket(int iSocket, char *pcBuf, WORD wLen,
				   NET_ADDR *psFrom, WORD wFlags);
int WriteSocket(int iSocket, char *pcBuf, WORD wLen, WORD wFlags);
int WriteToSocket(int iSocket, char *pcBuf, WORD wLen,
				  NET_ADDR *psTo, WORD wFlags);
int EofSocket(int iSocket);
int FlushSocket(int iSocket);
int ReleaseSocket(int iSocket);
int ReleaseDCSockets(void);
int AbortSocket(int iSocket);
int AbortDCSockets(void);
int ShutDownNet(void);
int SetAlarm(int iSocket,DWORD dwTime,int (D_FAR *lpHandler)(),
			 DWORD dwHint);
int D_FAR *SetAsyncNotification(int iSocket,int iEvent,
								int (D_FAR *lpHandler)(),DWORD dwHint);
//int ISR_ROUTINE D_FAR AsyncNotificationHandler(void);
DWORD ResolveName(char *pszName, char *pcCName, int iCNameLen);
DWORD ParseAddress(char *pszName);
int SetSocketOption(int iSocket,int iLevel,int iOption,
					DWORD dwOptionValue,int iLen);
int JoinGroup(DWORD dwGroupAddress, DWORD dwInterfaceAddress);
int LeaveGroup(DWORD dwGroupAddress, DWORD dwInterfaceAddress);
int IfaceIOCTL(char *pszName, WORD wFunction);
int GetSocketsVersion(void);

